(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 4.0,
MathReader 4.0, or any compatible application. The data for the notebook 
starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     33447,        973]*)
(*NotebookOutlinePosition[     34291,       1000]*)
(*  CellTagsIndexPosition[     34247,        996]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[
    \( (*\ Example\ 6.4  .4 \( a\ \  : \ 
            To\ compute\ e_Q\)\  = \ \(intx\  - \ int\n
        \tor\ \ e_Q\  = \ int\  - \ intx\)\ \ *) \)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(g[s_] := \ x^\((3/2)\)*s^3; \nPlot[s^3, \ {s, \ 0, \ \[Pi]}]\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.303152 0.0147151 0.0306087 [
[.17539 .00222 -9 -9 ]
[.17539 .00222 9 0 ]
[.32696 .00222 -3 -9 ]
[.32696 .00222 3 0 ]
[.47854 .00222 -9 -9 ]
[.47854 .00222 9 0 ]
[.63011 .00222 -3 -9 ]
[.63011 .00222 3 0 ]
[.78169 .00222 -9 -9 ]
[.78169 .00222 9 0 ]
[.93327 .00222 -3 -9 ]
[.93327 .00222 3 0 ]
[.01131 .16776 -6 -4.5 ]
[.01131 .16776 0 4.5 ]
[.01131 .3208 -12 -4.5 ]
[.01131 .3208 0 4.5 ]
[.01131 .47385 -12 -4.5 ]
[.01131 .47385 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.17539 .01472 m
.17539 .02097 L
s
[(0.5)] .17539 .00222 0 1 Mshowa
.32696 .01472 m
.32696 .02097 L
s
[(1)] .32696 .00222 0 1 Mshowa
.47854 .01472 m
.47854 .02097 L
s
[(1.5)] .47854 .00222 0 1 Mshowa
.63011 .01472 m
.63011 .02097 L
s
[(2)] .63011 .00222 0 1 Mshowa
.78169 .01472 m
.78169 .02097 L
s
[(2.5)] .78169 .00222 0 1 Mshowa
.93327 .01472 m
.93327 .02097 L
s
[(3)] .93327 .00222 0 1 Mshowa
.125 Mabswid
.05412 .01472 m
.05412 .01847 L
s
.08444 .01472 m
.08444 .01847 L
s
.11476 .01472 m
.11476 .01847 L
s
.14507 .01472 m
.14507 .01847 L
s
.2057 .01472 m
.2057 .01847 L
s
.23602 .01472 m
.23602 .01847 L
s
.26633 .01472 m
.26633 .01847 L
s
.29665 .01472 m
.29665 .01847 L
s
.35728 .01472 m
.35728 .01847 L
s
.38759 .01472 m
.38759 .01847 L
s
.41791 .01472 m
.41791 .01847 L
s
.44822 .01472 m
.44822 .01847 L
s
.50885 .01472 m
.50885 .01847 L
s
.53917 .01472 m
.53917 .01847 L
s
.56948 .01472 m
.56948 .01847 L
s
.5998 .01472 m
.5998 .01847 L
s
.66043 .01472 m
.66043 .01847 L
s
.69074 .01472 m
.69074 .01847 L
s
.72106 .01472 m
.72106 .01847 L
s
.75138 .01472 m
.75138 .01847 L
s
.81201 .01472 m
.81201 .01847 L
s
.84232 .01472 m
.84232 .01847 L
s
.87264 .01472 m
.87264 .01847 L
s
.90295 .01472 m
.90295 .01847 L
s
.96358 .01472 m
.96358 .01847 L
s
.9939 .01472 m
.9939 .01847 L
s
.25 Mabswid
0 .01472 m
1 .01472 L
s
.02381 .16776 m
.03006 .16776 L
s
[(5)] .01131 .16776 1 0 Mshowa
.02381 .3208 m
.03006 .3208 L
s
[(10)] .01131 .3208 1 0 Mshowa
.02381 .47385 m
.03006 .47385 L
s
[(15)] .01131 .47385 1 0 Mshowa
.125 Mabswid
.02381 .04532 m
.02756 .04532 L
s
.02381 .07593 m
.02756 .07593 L
s
.02381 .10654 m
.02756 .10654 L
s
.02381 .13715 m
.02756 .13715 L
s
.02381 .19837 m
.02756 .19837 L
s
.02381 .22898 m
.02756 .22898 L
s
.02381 .25958 m
.02756 .25958 L
s
.02381 .29019 m
.02756 .29019 L
s
.02381 .35141 m
.02756 .35141 L
s
.02381 .38202 m
.02756 .38202 L
s
.02381 .41263 m
.02756 .41263 L
s
.02381 .44324 m
.02756 .44324 L
s
.02381 .50445 m
.02756 .50445 L
s
.02381 .53506 m
.02756 .53506 L
s
.02381 .56567 m
.02756 .56567 L
s
.02381 .59628 m
.02756 .59628 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .01472 m
.02499 .01472 L
.02605 .01472 L
.02729 .01472 L
.02846 .01472 L
.02954 .01472 L
.03053 .01472 L
.03163 .01472 L
.03279 .01472 L
.03395 .01472 L
.0352 .01472 L
.03746 .01472 L
.03884 .01472 L
.04016 .01472 L
.04262 .01472 L
.045 .01473 L
.04753 .01473 L
.0521 .01474 L
.05489 .01475 L
.05752 .01476 L
.06244 .01478 L
.06757 .01481 L
.07299 .01485 L
.08269 .01494 L
.09312 .01508 L
.10458 .01529 L
.11478 .01554 L
.12409 .01582 L
.145 .01667 L
.16409 .01775 L
.18485 .0193 L
.20462 .02121 L
.22563 .02375 L
.26338 .02982 L
.30359 .03877 L
.34227 .0502 L
.38341 .0658 L
.42304 .08462 L
.46115 .10661 L
.50171 .13463 L
.54075 .16649 L
.58225 .20605 L
.62223 .25016 L
.6607 .29854 L
.70162 .35684 L
.74102 .42004 L
.77891 .48773 L
.81925 .56766 L
s
.81925 .56766 m
.84226 .61803 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/@P10`4000010?ooooooc?ooZ_ooI_oo
<ooo0?o<ooo<c?o<VC/k>gYjN[Vi^OShn03ooeGooj[ooonI<onI0?mVoomVc?mVVOmVI_mV<omV0?lc
oclo?ginO[fm_Oclo5D00:X00?l00?l0VOl0I_l0<ol00<coolcoc<coVLcoIP<30d92@X61PL30`000
EED0EJX0EOl0ELbIolbIc<bIVLbII/bI<lbI0<aVolaVc0L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0Z/`c
<l`c0<`0ol`0c<`0VL`0I/`0<l`000/;2dY:BXV9RLS8b000oeD0ojX0ool0oiW<VIW<IYW<<iW<09VI
oiVIc9VIVIVIIPl?3di>CXf=SLc<c01E05EE0:YE0?mE09TcoiTcc9TcVITcIYTc<iTc09T0oiT0c1<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEEFKo<fKo06K<ofK<c6K<VFK<IVK<<fK<01LG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZVIVVFIVIVIV<fIV06HcofHcc6HcVFHcIQ/K6eYJFYVIVMSHf01EoeEEojYEoomEoc?o
oc?oc3?oVC?oIS?o<c?o03?<oc?<c1lO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ03>I<c>I03=Voc=Vc3=V
VC=VIS=V<c=V02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZEC<0VC<0IS<0<c<0003oo`3oc03oV@3oIRLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2Io`2Ic02IV@2IIP2I<`2I001Vo`1Vc2/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`0c<`0c0000o`00c000V@00IP00<nh002l_;fi^KZf][Nc/k03o05Go0:[o0?oo0140
003^003M002k002Z0028001g001E03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@00M`00E@00A0008P00
4Nk^k]gMgK^k^cLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l08@000?l08@0003@00_l400;o0`03ob00
0olQ00?o1002o`<00olP00Co7`04o`<00_l300?o8@03oaD0000c0004o`00o`<00_l60003o`0001h0
00?o00008@000ol0000300;o1P000ol0000N0003o`00020000?o00000`02o`H000?o00008@000ol0
000B0000<`001?l00?l;0003o`0001h000?o00008@000ol0000;0003o`0001l000?o000080000ol0
000:0003o`00024000?o00004P0003<000Co003o2003ob4000?o00008@000ol0000800?o8`000ol0
000P0003o`0000H00olR00;o5@0003<000Co003o20000ol0000Q0003o`00024000?o000020000ol0
000P0004o`00oal000Co003o20000ol0000T0003o`000180000d00;o2@04oal00_lR00;o2P04ob00
0_lQ00;o2@04ob000olE00004P000ol0003o00`0000B0003o`000?l03000018000?o0000o`0<0000
4P000ol0003o00`0000;0?oo4ol300004P000ol000050003o`0000D000?o00001@000ol00004017o
00<0o`001P000ol000060003o`0000D000?o00001@000ol000060003o`0000D000?o00001@000ol0
00050003o`0000H000?o00001@000ol000050003o`0000D000?o00001P000ol000050003o`0000D0
00?o00001@000ol000060003o`0000D000?o00001@000ol000060003o`0000D000?o00001@000ol0
00050003o`0000H000?o00001@000ol000050003o`0000<0000B0003o`0002H000?o0000100;oaL0
00?o00009`000ol0000V0003o`0002H000?o00009`000ol0000C00004P000ol0000h00GocP000180
00?o0000?@04olX0000B0003o`0004401?o600004P000ol0001500?o``00018000?o0000B004okl0
000B00;oC@03ok`0000B0003o`0004l00oni00004P000ol0001B00Co]@00018000?o0000EP03ok80
000B0003o`0005T00on_00004P000ol0001L00?o[000018000?o0000G`02ojX0000B0003o`000640
0_nX00004P000ol0001S00;oYP0001800_mV00;oY000018000?o0000I`02oj80000B0003o`0006T0
0_nP00004P000ol0001[00;oWP00018000?o0000K@02oi`0000B0003o`0006l000?o0000V@000180
00?o0000L002oiT0000B0003o`0007800_nG00004P02ogD00_nE00004P000ol0001f0003o`000980
000B0003o`0007L000?o0000T@00018000?o0000N002oi40000B0003o`0007X000?o0000SP000180
00?o0000N`02ohh0000B0003o`0007d000?o0000R`00018000?o0000OP000ol0002:00004P02oh00
0_n:00004P000ol000210003o`0008L0000B0003o`00088000?o0000QP00018000?o0000P`02ohH0
000B0003o`0008D000?o0000P`00018000?o0000QP02oh<0000B0003o`0008P000?o0000P00000T0
0ol60003o`0008T000?o0000O`0000`000?o00000`000ol0002:0003o`0007h0000<0003o`0000<0
0_n<0003o`0007d0000900?o1P000ol0002<0003o`0007`000090003o`0000H000?o0000S@000ol0
001k00002@04o`D000?o0000SP000ol0001j00004P000ol0002?0003o`0007T0000B0003o`000900
00?o0000N000018000?o0000T@000ol0001g00004P000ol0002B0003o`0007H0000B00;oU0000ol0
001e00004P000ol0002D0003o`0007@0000B0003o`0009D000?o0000L`00018000?o0000U@000ol0
001c00004P000ol0002F0003o`000780000B0003o`0009L000?o0000L@00018000?o0000V0000ol0
001`00004P000ol0002I0003o`0006l0000B00;oV`000ol0001^00004P000ol0002K0003o`0006d0
000B0003o`0009`000?o0000K000018000?o0000W@000ol0001[00004P000ol0002N0003o`0006X0
000B0003o`0009l000?o0000J@00018000?o0000X0000ol0001X00004P000ol0002P0003o`0006P0
000B0003o`000:4000?o0000I`0001800_nS0003o`0006H0000B0003o`000:<000?o0000I@000180
00?o0000X`000ol0001U00004P000ol0002T0003o`0006@0000B0003o`000:D000?o0000H`000180
00?o0000YP000ol0001R00004P000ol0002W0003o`000640000B0003o`000:L000?o0000H@000180
0_nY0003o`000600000B0003o`000:T000?o0000G`00018000?o0000ZP000ol0001N00004P000ol0
002Z0003o`0005h0000B0003o`000:/000?o0000G@00018000?o0000[0000ol0001L00000`03o`@0
0_l60003o`000:`000?o0000G00000@000?o00000P001?l00?l50003o`000:d000?o0000F`0000@0
00?o00000P001?l00?l500;o[`000ol0001J000010000ol000020004o`00o`D000?o0000[P000ol0
001J000010000ol000020004o`00o`D000?o0000[`000ol0001I00000`02o`D00_l60003o`000;00
00?o0000F000018000?o0000/@000ol0001G00004P000ol0002a0003o`0005L0000B0003o`000;80
00?o0000EP00018000?o0000/`000ol0001E00004P000ol0002c0003o`0005D0000B00;o]@000ol0
001D00004P000ol0002e0003o`0005<0000B0003o`000;D000?o0000D`00018000?o0000]P000ol0
001B00004P000ol0002g0003o`000540000B0003o`000;L000?o0000D@00018000?o0000^0000ol0
001@00004P000ol0002h0003o`000500000B00;o^P000ol0001?00004P000ol0002j0003o`0004h0
000B0003o`000;X000?o0000CP00018000?o0000^`000ol0001=00004P000ol0002k0003o`0004d0
000B0003o`000;`000?o0000C000018000?o0000_@000ol0001;00004P000ol0002m0003o`0004/0
000B00;o_`000ol0001:00004P000ol0002n0003o`0004X0000B0003o`000;l000?o0000B@000180
00?o0000`0000ol0001800004P000ol000300003o`0004P0000B0003o`000<4000?o0000A`000180
00?o0000`P000ol0001600004P000ol000320003o`0004H0000B0003o`000<<000?o0000A@000180
0_o40003o`0004D0000B0003o`000<@000?o0000A000018000?o0000a@000ol0001300004P000ol0
00350003o`0004<0000B0003o`000<H000?o0000@P00018000?o0000aP000ol0001200000`03o`<0
0ol60003o`000<L000?o0000@@0000@000?o00001@000ol000030003o`000<P000?o0000@00000@0
00?o00001@000ol0000300;ob@000ol00010000010000ol0000200?o1P000ol000390003o`0003l0
00040003o`00008000?o00001P000ol000390003o`0003l0000300;o1004o`D000?o0000bP000ol0
000n00004P000ol0003;0003o`0003d0000B0003o`000</000?o0000?@00018000?o0000c0000ol0
000l00004P000ol0003<0003o`0003`0000B0003o`000<d000?o0000>`0001800_o>0003o`0003/0
000B0003o`000<h000?o0000>P00018000?o0000cP000ol0000j00004P000ol0003?0003o`0003T0
000B0003o`000<l000?o0000>@00018000?o0000d0000ol0000h00004P000ol0003@0003o`0003P0
000B0003o`000=4000?o0000=`0001800_oB0003o`0003L0000B0003o`000=8000?o0000=P000180
00?o0000dP000ol0000f00004P000ol0003C0003o`0003D0000B0003o`000=<000?o0000=@000180
00?o0000e0000ol0000d00004P000ol0003D0003o`0003@0000B0003o`000=D000?o0000<`000180
0_oF0003o`0003<0000B0003o`000=H000?o0000<P00018000?o0000eP000ol0000b00004P000ol0
003G0003o`000340000B0003o`000=L000?o0000<@00018000?o0000f0000ol0000`00004P000ol0
003H0003o`000300000B0003o`000=T000?o0000;`00018000?o0000f@000ol0000_00004P02omX0
00?o0000;`00018000?o0000fP000ol0000^00004P000ol0003J0003o`0002h0000B0003o`000=/0
00?o0000;@00018000?o0000f`000ol0000]00004P000ol0003L0003o`0002`00000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.218905, -1.48653, 
  0.012096, 0.1198}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\( (*\ Directly\ by\ Mma\ \ *) \n
    intx = Integrate[g[s], \ {s, \ 0, \[Pi]}] // N\)\)], "Input"],

Cell[BoxData[
    \(24.3522727585006082`\ x\^\(3/2\)\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\( (*\ By\ rectangular\ rule\ n = 2\ *) \n
    int = \((\[Pi]/2)\)*\((g[\[Pi]/2] + g[\[Pi]])\) // Simplify; \n
    eQ = \((int\  - \ intx)\) /. \ x -> \[Pi]\)\)], "Input"],

Cell[BoxData[
    \(169.501802734551354`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Clear[int]; \n (*\ Rectangular\ rule, \ n = 4\ *) \n
    int = \((\[Pi]/4)\)*
          \((\ g[0.25\ \[Pi]] + g[0.5\ \[Pi]] + g[0.75\ \[Pi]] + g[\[Pi]])
            \) // Simplify; \neQ = \((int\  - \ intx)\) /. \ x -> \[Pi]\)], 
  "Input"],

Cell[BoxData[
    \(76.2758112305480562`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Clear[int]; \n (*\ By\ Rectangular\ rule\ n = 10*) \n
    int = \((\[Pi]/10)\)*
          \((g[0.1\ \[Pi]] + g[0.2\ \[Pi]] + g[0.3\ \[Pi]] + g[0.4\ \[Pi]] + 
              g[0.5\ \[Pi]] + g[0.6\ \[Pi]] + g[0.7\ \[Pi]] + g[0.8\ \[Pi]] + 
              g[0.9\ \[Pi]] + g[\[Pi]])\) // Simplify; \n
    eQ = \((int\  - \ intx)\) /. \ x -> \[Pi]\)], "Input"],

Cell[BoxData[
    \(28.4763028594046208`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Clear[int]; \n (*\ By\ Rectangular\ rule\ n = 20*) \n
    int = \((\[Pi]/20)\)*
          \((g[0.05\ \[Pi]] + g[0.1\ \[Pi]] + g[0.15\ \[Pi]] + 
              g[0.2\ \[Pi]] + g[0.25\ \[Pi]] + g[0.3\ \[Pi]] + 
              g[0.35\ \[Pi]] + g[0.4\ \[Pi]] + g[0.45\ \[Pi]] + 
              g[0.5\ \[Pi]] + g[0.55\ \[Pi]] + g[0.6\ \[Pi]] + 
              g[0.65\ \[Pi]] + g[0.7\ \[Pi]] + g[0.75\ \[Pi]] + 
              g[0.8\ \[Pi]] + g[0.85\ \[Pi]] + g[0.9\ \[Pi]] + 
              g[0.95\ \[Pi]] + g[\[Pi]])\) // Simplify; \n
    eQ = \((int\  - \ intx)\) /. \ x -> \[Pi]\)], "Input"],

Cell[BoxData[
    \(13.8991478242331822`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Clear[int]; \n (*\ By\ Rectangular\ rule\ n = 40*) \n
    int = \((\[Pi]/40)\)*
          \((g[0.025\ \[Pi]] + g[0.05\ \[Pi]] + g[0.075\ \[Pi]] + 
              g[0.1\ \[Pi]] + g[0.125\ \[Pi]] + g[0.15\ \[Pi]] + 
              g[0.175\ \[Pi]] + g[0.2\ \[Pi]] + g[0.225\ \[Pi]] + 
              g[0.25\ \[Pi]] + g[0.275\ \[Pi]] + g[0.3\ \[Pi]] + 
              g[0.325\ \[Pi]] + g[0.35\ \[Pi]] + g[0.375\ \[Pi]] + 
              g[0.4\ \[Pi]] + g[0.425\ \[Pi]] + g[0.45\ \[Pi]] + 
              g[0.475\ \[Pi]] + g[0.5\ \[Pi]] + g[0.525\ \[Pi]] + 
              g[0.55\ \[Pi]] + g[0.575\ \[Pi]] + g[0.6\ \[Pi]] + 
              g[0.625\ \[Pi]] + g[0.65\ \[Pi]] + g[0.675\ \[Pi]] + 
              g[0.7\ \[Pi]] + g[0.725\ \[Pi]] + g[0.75\ \[Pi]] + 
              g[0.775\ \[Pi]] + g[0.8\ \[Pi]] + g[0.825\ \[Pi]] + 
              g[0.85\ \[Pi]] + g[0.875\ \[Pi]] + g[0.9\ \[Pi]] + 
              g[0.925\ \[Pi]] + g[0.95\ \[Pi]] + g[0.975\ \[Pi]] + g[\[Pi]])
            \) // Simplify; \neQ = \((int\  - \ intx)\) /. \ x -> \[Pi]\)], 
  "Input"],

Cell[BoxData[
    \(6.86482301074932621`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Clear[int]; \n (*\ Trapezoidal\ Rule\ n = 5\ *) \n
    int = \((\[Pi]/10)\)*
          \((\ g[0] + 2*g[0.2\ \[Pi]] + 2*g[0.4\ \[Pi]] + 2*g[0.6\ \[Pi]] + 
              2*g[0.8\ \[Pi]] + g[\[Pi]])\) // Simplify; \n
    eQ = \((int\  - \ intx)\) /. \ x -> \[Pi]\)], "Input"],

Cell[BoxData[
    \(5.42405768750564121`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Clear[int]; \n (*\ Trapezoidal\ Rule\ n = 10\ *) \n
    int = \((\[Pi]/20)\)*
          \((\ g[0] + 2*g[0.1\ \[Pi]] + 2*g[0.2\ \[Pi]] + 2*g[0.3\ \[Pi]] + 
              2*g[0.4\ \[Pi]] + 2*g[0.5\ \[Pi]] + 2*g[0.6\ \[Pi]] + 
              2*g[0.7\ \[Pi]] + 2*g[0.8\ \[Pi]] + 2*g[0.9\ \[Pi]] + g[\[Pi]])
            \) // Simplify; \neQ = \((int\  - \ intx)\) /. \ x -> \[Pi]\)], 
  "Input"],

Cell[BoxData[
    \(1.35601442187639054`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Clear[int]; \n (*\ Trapezoidal\ Rule\ n = 20\ *) \n
    int = \((\[Pi]/40)\)*
          \((\ g[0] + 2*g[0.05\ \[Pi]] + 2*g[0.1\ \[Pi]] + 2*g[0.15\ \[Pi]] + 
              2*g[0.2\ \[Pi]] + 2*g[0.25\ \[Pi]] + 2*g[0.3\ \[Pi]] + 
              2*g[0.35\ \[Pi]] + 2*g[0.4\ \[Pi]] + 2*g[0.45\ \[Pi]] + 
              2*g[0.5\ \[Pi]] + 2*g[0.55\ \[Pi]] + 2*g[0.6\ \[Pi]] + 
              2*g[0.65\ \[Pi]] + 2*g[0.7\ \[Pi]] + 2*g[0.75\ \[Pi]] + 
              2*g[0.8\ \[Pi]] + 2*g[0.85\ \[Pi]] + 2*g[0.9\ \[Pi]] + 
              2*g[0.95\ \[Pi]] + g[\[Pi]])\) // Simplify; \n
    eQ = \((int\  - \ intx)\) /. \ x -> \[Pi]\)], "Input"],

Cell[BoxData[
    \(0.339003605469097646`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Clear[int]; \n (*\ Trapezoidal\ Rule\ n = 40\ *) \n
    int = \((\[Pi]/80)\)*
          \((\ g[0] + 2*g[0.025\ \[Pi]] + 2*g[0.05\ \[Pi]] + 
              2*g[0.075\ \[Pi]] + \n\t\t\t\ \ \ \ \ \ 2*g[0.1\ \[Pi]] + 
              2*g[0.125\ \[Pi]] + 2*g[0.15\ \[Pi]] + 2*g[0.175\ \[Pi]] + 
              2*g[0.2\ \[Pi]] + 2*g[0.225\ \[Pi]] + 2*g[0.25\ \[Pi]] + 
              2*g[0.275\ \[Pi]] + 2*g[0.3\ \[Pi]] + 2*g[0.325\ \[Pi]] + 
              2*g[0.35\ \[Pi]] + 2*g[0.375\ \[Pi]] + 2*g[0.4\ \[Pi]] + 
              2*g[0.425\ \[Pi]] + 2*g[0.45\ \[Pi]] + 2*g[0.475\ \[Pi]] + 
              2*g[0.5\ \[Pi]] + 2*g[0.525\ \[Pi]] + 2*g[0.55\ \[Pi]] + 
              2*g[0.575\ \[Pi]] + 2*g[0.6\ \[Pi]] + 2*g[0.625\ \[Pi]] + 
              2*g[0.65\ \[Pi]] + 2*g[0.675\ \[Pi]] + 2*g[0.7\ \[Pi]] + 
              2*g[0.725\ \[Pi]] + 2*g[0.75\ \[Pi]] + 2*g[0.775\ \[Pi]] + 
              2*g[0.8\ \[Pi]] + 2*g[0.825\ \[Pi]] + 2*g[0.85\ \[Pi]] + 
              2*g[0.875\ \[Pi]] + 2*g[0.9\ \[Pi]] + 2*g[0.925\ \[Pi]] + 
              2*g[0.95\ \[Pi]] + 2*g[0.975\ \[Pi]] + g[\[Pi]])\) // Simplify; 
    \neQ = \((int\  - \ intx)\) /. \ x -> \[Pi]\)], "Input"],

Cell[BoxData[
    \(0.084750901367274416`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Clear[int]; \n (*\ By\ Simpson' s\ Rule\ n = 5\ *) \n
    int = \((\[Pi]/15)\)*
          \((\ g[0] + 4*g[0.25\ \[Pi]] + 2*g[0.5\ \[Pi]] + 4*g[0.75\ \[Pi]] + 
              g[\[Pi]])\) // Simplify; \n
    eQ = \((intx\  - \ int)\) /. \ x -> \[Pi]\)], "Input"],

Cell[BoxData[
    \(27.1202884375282282`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Clear[int]; \n (*\ By\ Simpson' s\ Rule\ n = 7\ *) \n
    int = \(\((\[Pi]/21)\)*
            \((\ g[0] + 4*g[\[Pi]/6] + 2*g[\[Pi]/3] + 4*g[\[Pi]/2] + \n
                \t\t\t\t2*g[2\ \[Pi]/3] + 4*g[5\ \[Pi]/6] + g[\[Pi]])\) // 
          Simplify\) // N; \neQ = \((intx\  - \ int)\) /. \ x -> \[Pi]\)], 
  "Input"],

Cell[BoxData[
    \(19.3716345982344364`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Clear[int]; \n (*\ By\ Simpson' s\ Rule\ n = 9*) \n
    int = \(\((\[Pi]/27)\)*
            \((\ g[0] + 4*g[\[Pi]/8] + 2*g[\[Pi]/4] + 4*g[3\ \[Pi]/8] + \n
                \t\t\t\t2*g[\[Pi]/2] + 4*g[5\ \[Pi]/8] + 2*g[3\ \[Pi]/4] + 
                4*g[7\ \[Pi]/8] + g[\[Pi]])\) // Simplify\) // N; \n
    eQ = \((intx\  - \ int)\) /. \ x -> \[Pi]\)], "Input"],

Cell[BoxData[
    \(15.0668269097379114`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Clear[int]; \n (*\ By\ Simpson' s\ Rule\ n = 11*) \n
    int = \(\((\[Pi]/33)\)*
            \((\ g[0] + 4*g[\[Pi]/10] + 2*g[\[Pi]/5] + 4*g[3\ \[Pi]/10] + \n
                \t\t\t\t2*g[2\ \[Pi]/5] + 4*g[\[Pi]/2] + 2*g[3\ \[Pi]/5] + 
                4*g[7\ \[Pi]/10] + 2*g[4\ \[Pi]/5] + 4*g[9\ \[Pi]/10] + 
                g[\[Pi]])\) // Simplify\) // N; \n
    eQ = \((intx - \ int)\) /. \ x -> \[Pi]\)], "Input"],

Cell[BoxData[
    \(12.3274038352400916`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Clear[int]; \n (*\ By\ Simpson' s\ Rule\ n = 17*) \n
    int = \(\((\[Pi]/51)\)*
            \((\ g[0] + 4*g[\[Pi]/16] + 2*g[2\ \[Pi]/16] + 4*g[3\ \[Pi]/16] + 
                \n\t\t\t\t2*g[4\ \[Pi]/16] + 4*g[5\ \[Pi]/16] + 
                2*g[6\ \[Pi]/16] + 4*g[7\ \[Pi]/16] + 2*g[8\ \[Pi]/16] + 
                4*g[9\ \[Pi]/16] + 2*g[10\ \[Pi]/16] + 4*g[11\ \[Pi]/16] + 
                2*g[12\ \[Pi]/16] + 4*g[13\ \[Pi]/16] + 2*g[14\ \[Pi]/16] + 
                4*g[15\ \[Pi]/16] + g[\[Pi]])\) // Simplify\) // N; \n
    eQ = \((intx\  - \ int)\) /. \ x -> \[Pi]\)], "Input"],

Cell[BoxData[
    \(7.97655542280242091`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Clear[int]; \n (*\ By\ Simpson' s\ Rule\ n = 33*) \n
    int = \(\((\[Pi]/99)\)*
            \((\ g[0] + 4*g[\[Pi]/32] + 2*g[2\ \[Pi]/32] + 4*g[3\ \[Pi]/32] + 
                \n\t\t\t\t2*g[4\ \[Pi]/32] + 4*g[5\ \[Pi]/32] + 
                2*g[6\ \[Pi]/32] + 4*g[7\ \[Pi]/32] + 2*g[8\ \[Pi]/32] + 
                4*g[9\ \[Pi]/32] + 2*g[10\ \[Pi]/32] + 4*g[11\ \[Pi]/32] + 
                2*g[12\ \[Pi]/32] + 4*g[13\ \[Pi]/32] + 2*g[14\ \[Pi]/32] + 
                4*g[15\ \[Pi]/32] + 2*g[16\ \[Pi]/32] + 4*g[17\ \[Pi]/32] + 
                2*g[18\ \[Pi]/32] + 4*g[19\ \[Pi]/32] + 2*g[20\ \[Pi]/32] + 
                4*g[21\ \[Pi]/32] + 2*g[22\ \[Pi]/32] + 4*g[23\ \[Pi]/32] + 
                2*g[24\ \[Pi]/32] + 4*g[25\ \[Pi]/32] + 2*g[26\ \[Pi]/32] + 
                4*g[27\ \[Pi]/32] + 2*g[28\ \[Pi]/32] + 4*g[29\ \[Pi]/32] + 
                4*g[30\ \[Pi]/32] + 4*g[31\ \[Pi]/32] + g[\[Pi]])\) // 
          Simplify\) // N; \neQ = \((int\  - \ intx)\) /. \ x -> \[Pi]\)], 
  "Input"],

Cell[BoxData[
    \(4.91972561914206263`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Clear[int]; \n (*\ Tangential\ Rule\ n = 5\ *) \n
    int = \((\[Pi]/5)\)*\ 
          \((g[0.1\ \[Pi]] + g[0.3\ \[Pi]] + g[0.5\ \[Pi]] + g[0.7\ \[Pi]] + 
              g[0.9\ \[Pi]])\) // Simplify; \n
    eQ = \((intx\  - \ int)\) /. \ x -> \[Pi]\)], "Input"],

Cell[BoxData[
    \(2.71202884375284059`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Clear[int]; \n (*\ Tangential\ Rule\ n = 10\ *) \n
    int = \(\((\[Pi]/10)\)*\ 
            \((g[\[Pi]/20] + g[3\ \[Pi]/20] + g[5\ \[Pi]/20] + 
                g[7\ \[Pi]/20] + g[9\ \[Pi]/20] + g[11\ \[Pi]/20] + 
                g[13\ \[Pi]/20] + g[15\ \[Pi]/20] + g[17\ \[Pi]/20] + 
                g[19\ \[Pi]/20])\) // Simplify\) // N; \n
    eQ = \((intx\  - \ int)\) /. \ x -> \[Pi]\)], "Input"],

Cell[BoxData[
    \(0.67800721093821501`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Clear[int]; \n (*\ Tangential\ Rule\ n = 20\ *) \n
    int = \(\((\[Pi]/20)\)*\ 
            \((g[\[Pi]/40] + g[3\ \[Pi]/40] + g[5\ \[Pi]/40] + 
                g[7\ \[Pi]/40] + g[9\ \[Pi]/40] + g[11\ \[Pi]/40] + 
                g[13\ \[Pi]/40] + g[15\ \[Pi]/40] + g[17\ \[Pi]/40] + 
                g[19\ \[Pi]/40] + g[21\ \[Pi]/40] + g[23\ \[Pi]/40] + 
                g[25\ \[Pi]/40] + g[27\ \[Pi]/40] + g[29\ \[Pi]/40] + 
                g[31\ \[Pi]/40] + g[33\ \[Pi]/40] + g[35\ \[Pi]/40] + 
                g[37\ \[Pi]/40] + g[39\ \[Pi]/40])\) // Simplify\) // N; \n
    eQ = \((intx\  - \ int)\) /. \ x -> \[Pi]\)], "Input"],

Cell[BoxData[
    \(0.169501802734548823`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Clear[int]; \n (*\ Weddle\ Rule\ n = 7\ *) \n
    int = \(\((3\ \[Pi]/70)\)*
            \((g[0] + 5*g[\[Pi]/7] + g[2\ \[Pi]/7] + 6*g[3\ \[Pi]/7] + 
                g[4\ \[Pi]/7] + 5*g[5\ \[Pi]/7] + 2*g[6\ \[Pi]/7] + g[\[Pi]])
              \) // Simplify\) // N; \n
    eQ = \((intx\  - \ int)\) /. \ x -> \[Pi]\)], "Input"],

Cell[BoxData[
    \(24.5223432727504064`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Clear[int]; \nClear[int, \[CurlyPhi]]; 
    \n (*\ Weddle\ Rule\ n = 13\ *) \n
    int = \(\((3\ \[Pi]/130)\)*
            \((g[0] + 5*g[\[Pi]/13] + g[2\ \[Pi]/13] + 6*g[3\ \[Pi]/13] + 
                g[4\ \[Pi]/13] + 5*g[5\ \[Pi]/13] + 2*g[6\ \[Pi]/13] + 
                5*g[7\ \[Pi]/13] + g[8\ \[Pi]/13] + 6*g[9\ \[Pi]/13] + 
                g[10\ \[Pi]/13] + 5*g[11\ \[Pi]/13] + 2*g[12\ \[Pi]/13] + 
                g[\[Pi]])\) // Simplify\) // N; \n
    eQ = \((intx\  - \ int)\) /. \ x -> \[Pi]\)], "Input"],

Cell[BoxData[
    \(14.7893453455586998`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Clear[int]; \n (*\ Weddle\ Rule\ n = 19\ *) \n
    int = \(\((3\ \[Pi]/190)\)*
            \((g[0] + 5*g[\[Pi]/19] + g[2\ \[Pi]/19] + 6*g[3\ \[Pi]/19] + 
                g[4\ \[Pi]/19] + 5*g[5\ \[Pi]/19] + 2*g[6\ \[Pi]/19] + 
                5*g[7\ \[Pi]/19] + g[8\ \[Pi]/19] + 6*g[9\ \[Pi]/19] + 
                g[10\ \[Pi]/19] + 5*g[11\ \[Pi]/19] + 2*g[12\ \[Pi]/19] + \n
                \t\t\t\t5*g[13\ \[Pi]/19] + g[14\ \[Pi]/19] + 
                6*g[15\ \[Pi]/19] + g[16\ \[Pi]/19] + 5*g[17  \[Pi]/19] + 
                2*g[18\ \[Pi]/19] + g[\[Pi]])\) // Simplify\) // N; \n
    eQ = \((intx\  - \ int)\) /. \ x -> \[Pi]\)], "Input"],

Cell[BoxData[
    \(10.5256794291153354`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Clear[int]; \n (*\ Weddle\ Rule\ n = 25\ *) \n
    int = \(\((3\ \[Pi]/250)\)*
            \((g[0] + 5*g[\[Pi]/25] + g[2\ \[Pi]/25] + 6*g[3\ \[Pi]/25] + 
                g[4\ \[Pi]/25] + 5*g[5\ \[Pi]/25] + 2*g[6\ \[Pi]/25] + 
                5*g[7\ \[Pi]/25] + g[8\ \[Pi]/25] + 6*g[9\ \[Pi]/25] + 
                g[10\ \[Pi]/25] + 5*g[11\ \[Pi]/25] + 2*g[12\ \[Pi]/25] + \n
                \t\t\t\t5*g[13\ \[Pi]/25] + g[14\ \[Pi]/25] + 
                6*g[15\ \[Pi]/25] + g[16\ \[Pi]/25] + 5*g[17\ \[Pi]/25] + 
                2*g[18\ \[Pi]/25] + \n\t\t\t\t5*g[19\ \[Pi]/25] + 
                g[20\ \[Pi]/25] + 6*g[21\ \[Pi]/25] + g[22\ \[Pi]/25] + 
                5*g[23\ \[Pi]/25] + 2*g[24\ \[Pi]/25] + g[\[Pi]])\) // 
          Simplify\) // N; \neQ = \((intx\  - \ int)\) /. \ x -> \[Pi]\)], 
  "Input"],

Cell[BoxData[
    \(8.16132358686688696`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Clear[int]; \n (*\ Weddle\ Rule\ n = 31\ *) \n
    int = \(\((3\ \[Pi]/310)\)*
            \((g[0] + 5*g[\[Pi]/31] + g[2\ \[Pi]/31] + 6*g[3\ \[Pi]/31] + 
                g[4\ \[Pi]/31] + 5*g[5\ \[Pi]/31] + 2*g[6\ \[Pi]/31] + 
                5*g[7\ \[Pi]/31] + g[8\ \[Pi]/31] + 6*g[9\ \[Pi]/31] + 
                g[10\ \[Pi]/31] + 5*g[11\ \[Pi]/31] + 2*g[12\ \[Pi]/31] + \n
                \t\t\t\t5*g[13\ \[Pi]/31] + g[14\ \[Pi]/31] + 
                6*g[15\ \[Pi]/31] + g[16\ \[Pi]/31] + 5*g[17\ \[Pi]/31] + 
                2*g[18\ \[Pi]/31] + \n\t\t\t\t5*g[19\ \[Pi]/31] + 
                g[20\ \[Pi]/31] + 6*g[21\ \[Pi]/31] + g[22\ \[Pi]/31] + 
                5*g[23\ \[Pi]/31] + 2*g[24\ \[Pi]/31] + 5*g[25\ \[Pi]/31] + 
                g[26\ \[Pi]/31] + 6*g[27\ \[Pi]/31] + g[28\ \[Pi]/31] + 
                5*g[29\ \[Pi]/31] + 2*g[30\ \[Pi]/31] + g[\[Pi]])\) // 
          Simplify\) // N; \neQ = \((intx\  - \ int)\) /. \ x -> \[Pi]\)], 
  "Input"],

Cell[BoxData[
    \(6.66198333838560419`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Clear[int]; \n (*\ Weddle\ Rule\ n = 37*) \n
    int = \(\((3\ \[Pi]/370)\)*
            \((g[0] + 5*g[\[Pi]/37] + g[2\ \[Pi]/37] + 6*g[3\ \[Pi]/37] + 
                g[4\ \[Pi]/37] + 5*g[5\ \[Pi]/37] + 2*g[6\ \[Pi]/37] + 
                5*g[7\ \[Pi]/37] + g[8\ \[Pi]/37] + 6*g[9\ \[Pi]/37] + 
                g[10\ \[Pi]/37] + 5*g[11\ \[Pi]/37] + 2*g[12\ \[Pi]/37] + \n
                \t\t\t\t5*g[13\ \[Pi]/37] + g[14\ \[Pi]/37] + 
                6*g[15\ \[Pi]/37] + g[16\ \[Pi]/37] + 5*g[17\ \[Pi]/37] + 
                2*g[18\ \[Pi]/37] + \n\t\t\t\t5*g[19\ \[Pi]/37] + 
                g[20\ \[Pi]/37] + 6*g[21\ \[Pi]/37] + g[22\ \[Pi]/37] + 
                5*g[23\ \[Pi]/37] + 2*g[24\ \[Pi]/37] + 5*g[25\ \[Pi]/37] + 
                g[26\ \[Pi]/37] + 6*g[27\ \[Pi]/37] + g[28\ \[Pi]/37] + 
                5*g[29\ \[Pi]/37] + 2*g[30\ \[Pi]/37] + \n\t\t\t\t\t\t\t
                5*g[31\ \[Pi]/37] + g[32\ \[Pi]/37] + 6*g[33\ \[Pi]/37] + 
                g[34\ \[Pi]/37] + 5*g[35\ \[Pi]/37] + 2*g[36\ \[Pi]/37] + 
                g[\[Pi]])\) // Simplify\) // N; \n
    eQ = \((intx\  - \ int)\) /. \ x -> \[Pi]\)], "Input"],

Cell[BoxData[
    \(5.62720795331352086`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Clear[int]; \n (*\ Weddle\ Rule\ n = 43*) \n
    int = \(\((3\ \[Pi]/430)\)*
            \((g[0] + 5*g[\[Pi]/43] + g[2\ \[Pi]/43] + 6*g[3\ \[Pi]/43] + 
                g[4\ \[Pi]/43] + 5*g[5\ \[Pi]/43] + 2*g[6\ \[Pi]/43] + 
                5*g[7\ \[Pi]/43] + g[8\ \[Pi]/43] + 6*g[9\ \[Pi]/43] + 
                g[10\ \[Pi]/43] + 5*g[11\ \[Pi]/43] + 2*g[12\ \[Pi]/43] + \n
                \t\t\t\t5*g[13\ \[Pi]/43] + g[14\ \[Pi]/43] + 
                6*g[15\ \[Pi]/43] + g[16\ \[Pi]/43] + 5*g[17\ \[Pi]/43] + 
                2*g[18\ \[Pi]/43] + \n\t\t\t\t5*g[19\ \[Pi]/43] + 
                g[20\ \[Pi]/43] + 6*g[21\ \[Pi]/43] + g[22\ \[Pi]/43] + 
                5*g[23\ \[Pi]/43] + 2*g[24\ \[Pi]/43] + 5*g[25\ \[Pi]/43] + 
                g[26\ \[Pi]/43] + 6*g[27\ \[Pi]/43] + g[28\ \[Pi]/43] + 
                5*g[29\ \[Pi]/43] + 2*g[30\ \[Pi]/43] + \n\t\t\t\t\t\t\t
                5*g[31\ \[Pi]/43] + g[32\ \[Pi]/43] + 6*g[33\ \[Pi]/43] + 
                g[34\ \[Pi]/43] + 5*g[35\ \[Pi]/43] + 2*g[36\ \[Pi]/43] + 
                5*g[37\ \[Pi]/43] + g[38\ \[Pi]/43] + 6*g[39\ \[Pi]/43] + 
                g[40\ \[Pi]/43] + 5*g[41\ \[Pi]/43] + 2*g[42\ \[Pi]/43] + 
                g[\[Pi]])\) // Simplify\) // N; \n
    eQ = \((intx\  - \ int)\) /. \ x -> \[Pi]\)], "Input"],

Cell[BoxData[
    \(4.87031467688896313`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Clear[int]; \n (*\ By\ Gauss - Legendre\ rule\ n = 2*) \n
    int = 0.5\ \[Pi]*
          \((g[0.663896644677787772`] + g[2.47769600891200525`])\) // 
        Simplify; \neQ = \((intx\  - \ int)\) /. \ x -> \[Pi]\)], "Input"],

Cell[BoxData[
    \(3.95653500847835992`*^-14\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Clear[int]; \n (*\ Gauss - Legendre\ Rule\ n = 4\ *) \n
    int = \ \[Pi]\ *
          \((0.1739274226*g[0.218126571673253266`] + 
              0.3260725774*g[1.03675535235190863`] + 
              0.3260725774*g[2.10483730123788426`] + 
              0.1739274226*g[2.92346608191653967`])\) // Simplify; \n
    eQ = \((int\  - \ intx)\) /. \ x -> \[Pi]\)], "Input"],

Cell[BoxData[
    \(7.96353562098986333`*^-9\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Clear[int]; 
    \n (*\ By\ Chebyshev\ Rule\ n = 6\ , \ 
      chebyshevpoints\ from\ the\ file\ chebyshevpoints . nb\ *) \n
    int = \((1/6)\)*
          \((g[0.0170370868554658567`]\  + \n\t\t\t\t
              g[0.146446609406726224`] + g[0.370590477448738297`] + 
              g[0.62940952255127458`] + g[0.853553390593233451`] + 
              g[0.982962913144561944`])\) // Simplify; \n
    eQ = \((intx\  - \ int)\) /. \ x -> \[Pi]\)], "Input"],

Cell[BoxData[
    \(133.861339688631142`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Clear[int]; 
    \n (*\ By\ Chebyshev\ Rule\ n = 8\ , \ 
      chebyshevpoints\ from\ the\ file\ chebyshevpoints . nb\ *) \n
    int = \((1/8)\)*
          \((g[0.00960735979838477582`]\  + \n\t\t\t\t
              g[0.0842651938487273355`] + g[0.222214883490200598`] + 
              g[0.402454838991917007`] + g[0.597545161008159819`] + 
              g[0.777785116509540586`] + g[0.915734806151648328`] + 
              g[0.990392640201421059`])\) // Simplify; \n
    eQ = \((intx\  - \ int)\) /. \ x -> \[Pi]\)], "Input"],

Cell[BoxData[
    \(133.861339688631142`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Clear[int]; \n (*\ By\ Newton - Cotes\ rule\ n = 4\ *) \n
    int = \(\((7*g[0] + 32*g[0.25] + 12*g[0.5] + 32*g[0.75] + 7*g[1])\)/90 // 
          N\) // Simplify; \neQ = \((intx\  - \ int)\) /. \ x -> \[Pi]\)], 
  "Input"],

Cell[BoxData[
    \(134.209360188433124`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Clear[int]; \n (*\ By\ Newton - Cotes\ rule\ n = 5\ *) \n
    int = \(\((
              19*g[0] + 75*g[0.2] + 50*g[0.4] + 50*g[0.6] + 75*g[0.8] + 
                19*g[1])\)/288 // N\) // Simplify; \n
    eQ = \((intx\  - \ int)\) /. \ x -> \[Pi]\)], "Input"],

Cell[BoxData[
    \(134.209360188433124`\)], "Output"]
}, Open  ]]
},
FrontEndVersion->"4.0 for Macintosh",
ScreenRectangle->{{0, 832}, {0, 604}},
WindowSize->{520, 509},
WindowMargins->{{28, Automatic}, {30, Automatic}},
MacintoshSystemPageSetup->"\<\
00<0001804P000000]P2:?oQon82n@960dL5:0?l0080001804P000000]P2:001
0000I00000400`<300000BL?00400@0000000000000006P801T1T00000000000
00000000000000000000000000000000\>"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1717, 49, 174, 3, 43, "Input"],

Cell[CellGroupData[{
Cell[1916, 56, 93, 1, 43, "Input"],
Cell[2012, 59, 10745, 370, 186, 3957, 282, "GraphicsData", "PostScript", \
"Graphics"],
Cell[12760, 431, 130, 3, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[12927, 439, 119, 2, 43, "Input"],
Cell[13049, 443, 66, 1, 28, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[13152, 449, 191, 3, 59, "Input"],
Cell[13346, 454, 54, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[13437, 460, 260, 5, 91, "Input"],
Cell[13700, 467, 54, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[13791, 473, 373, 6, 123, "Input"],
Cell[14167, 481, 54, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[14258, 487, 603, 10, 155, "Input"],
Cell[14864, 499, 54, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[14955, 505, 1064, 17, 235, "Input"],
Cell[16022, 524, 54, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[16113, 530, 292, 5, 91, "Input"],
Cell[16408, 537, 54, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[16499, 543, 409, 7, 123, "Input"],
Cell[16911, 552, 54, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[17002, 558, 648, 10, 187, "Input"],
Cell[17653, 570, 55, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[17745, 576, 1173, 17, 299, "Input"],
Cell[18921, 595, 55, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[19013, 601, 279, 5, 107, "Input"],
Cell[19295, 608, 54, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[19386, 614, 336, 6, 91, "Input"],
Cell[19725, 622, 54, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[19816, 628, 378, 6, 123, "Input"],
Cell[20197, 636, 54, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[20288, 642, 434, 7, 123, "Input"],
Cell[20725, 651, 54, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[20816, 657, 601, 9, 187, "Input"],
Cell[21420, 668, 54, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[21511, 674, 1015, 15, 267, "Input"],
Cell[22529, 691, 54, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[22620, 697, 280, 5, 107, "Input"],
Cell[22903, 704, 54, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[22994, 710, 421, 7, 123, "Input"],
Cell[23418, 719, 54, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[23509, 725, 652, 10, 171, "Input"],
Cell[24164, 737, 55, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[24256, 743, 345, 6, 107, "Input"],
Cell[24604, 751, 54, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[24695, 757, 534, 9, 171, "Input"],
Cell[25232, 768, 54, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[25323, 774, 662, 10, 187, "Input"],
Cell[25988, 786, 54, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[26079, 792, 831, 13, 219, "Input"],
Cell[26913, 807, 54, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[27004, 813, 981, 15, 251, "Input"],
Cell[27988, 830, 54, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[28079, 836, 1153, 17, 283, "Input"],
Cell[29235, 855, 54, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[29326, 861, 1303, 19, 315, "Input"],
Cell[30632, 882, 54, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[30723, 888, 245, 4, 91, "Input"],
Cell[30971, 894, 59, 1, 28, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[31067, 900, 387, 7, 139, "Input"],
Cell[31457, 909, 58, 1, 28, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[31552, 915, 473, 9, 187, "Input"],
Cell[32028, 926, 54, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[32119, 932, 545, 10, 219, "Input"],
Cell[32667, 944, 54, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[32758, 950, 243, 4, 107, "Input"],
Cell[33004, 956, 54, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[33095, 962, 279, 5, 107, "Input"],
Cell[33377, 969, 54, 1, 26, "Output"]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

